<?php 
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/costanti.php";
    include "include/util.php";
    include "gUtil/DbManager.php";
    include "classi/GeneratoreUrl.php";
    include "template/stile.php";
    include "classi/GestoreJavascript.php";
    include "template/include/includeClassiTemplate.php";

    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);		
    $gestoreJavascript = new GestoreJavascript();

    $impostazioni = recuperaImpostazioni($geecomDb);
    $configurazioneAspetto = $geecomDb->leggiSingolaRiga("geec_configurazioniAspetto", "si","selezionataAdmin");
    $inclusioni            = $geecomDb->leggiSingolaRiga("geecAd_inclusioni", 1);
    $tipo = filter_input(INPUT_GET,"tipo",FILTER_SANITIZE_STRING);

    session_start();
    if(!isset($_SESSION["geecomUser_email"]) ) {
        header("Location: index.php");
    }
    else {
	$utente = $geecomDb->leggiSingolaRIga("geec_utenti",$_SESSION["geecomUser_id"]);
    }
    
    $lingua = "italiano";
?>
<html>

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <meta name="generator" content="Geecom Admin"/>
    <title><?php echo $impostazioni["nomePiattaforma"]; ?></title>

    <!-- Favicon-->
    <link rel="icon" href="favicon.ico" type="image/x-icon">
	
	<?php 
            include "include/includeCssBase.php";
	?>
    	<link rel="stylesheet" href="plugins/OwlCarousel2/assets/owl.carousel.min.css">
</head>

<body>

    <div class="wrapper">
        <?php
            include "template/include/menuPrincipale.php";
        ?>
        <!-- Contenuto principale  -->
        <div id="content" class="p-0 extramargin d-flex flex-column">
            <div class="page-wrapper">
                <?php
                    include "template/include/barraSuperiore.php";
                ?>
                <main class="p-4">
                        <div class="row">
                                <?php
                                    if($tipo=="ticket") {
                                ?>
		                    <div class="col-lg-5">
		                        <div class="card bg-light border-0 p-3">
		                            <h5 class="mb-3">Crea un ticket</h5>
		                            <div class="btn-group float-right d-lg-none" role="group" aria-label="Basic example">
		                            	<button class="btn btn-light " data-toggle="collapse" href="#nuovoTicket"> <i class="fas fa-plus fa-xs"></i> </button>
		                            </div>

		                            <div id="nuovoTicket" class="collapse show in">
		                                <form name="formCreaTicket" action="controller/controllerComunicazioni.php" method="POST">
		                                    <input class="d-none" type="text" name="id" value="0">
		                                    <input class="d-none" type="text" name="operazione" value="creaTicket">
		                                    <div class="form-group">
		                                        <input type="text" class="form-control" id="oggetto" name="oggetto" placeholder="Oggetto">
		                                    </div>
		                                    <div class="form-group">
		                                        <textarea class="form-control tiny" id="testo" rows="5" name="testo" placeholder="Scrivi qui il tuo ticket"></textarea>
		                                    </div>
		                                    <div class="form-group">
		                                        <select class="form-control" name="priorita" id="exampleFormControlSelect1">
		                                            <option value="bassa">Priorità Bassa</option>
		                                            <option value="media">Priorità Media</option>
		                                            <option value="alta">Priorità Alta</option>
		                                        </select>
		                                    </div>
		                                    <div class="text-right">
		                                        <button type="button" id="pulsanteCreaTicket" class="btn btn-primary invia" onclick="inviaNuovoTicket()">Invia</button>
		                                    </div>
		                                </form>
		                            </div>	
		                        </div>
		                    </div>
                                <?php 
                                    }
                                ?>
                            <div class="<?= ($tipo=="ticket") ? "col-lg-7" : "col-12" ?>">
                                <?php
                                    $visualizzatore = new VisualizzatoreComunicazioni($geecomDb,null);
                                    $visualizzatore->generaContenuto(array("tipo"=>$tipo));
                                ?>
                            </div>
                        </div>
                </main>
            </div>
        <?php
            include "template/include/footer.php";
        ?>
        </div>
    </div>
    <?php 
	 if($impostazioni["accessoFacebook"]=="si") {
            include "include/facebookSdk.php";
	 }

        include"include/includeJsBase.php"; 
        include"template/include/includeJsTemplate.php"; 
    ?>
    
    <script>
        function inviaNuovoTicket() {
            var oggetto = document.getElementById("oggetto").value;
            var testo   = tinymce.activeEditor.getContent();
            
            if(oggetto=="") {
                alert("Inserisci l'oggetto");
            }
            else if(testo=="") {
                alert("Spiega il problema");
                alert("testo attuale:"+testo);
            }
            else if(oggetto.indexOf("<script>")>-1 || testo.indexOf("<script>")>-1) {
                alert("Attenzione: non puoi inserire script nei campi di testo");
            }
            else {
                document.getElementById("pulsanteCreaTicket").disabled = true;
                document.formCreaTicket.submit();
            }
        }
    </script>
</body>

</html>
